﻿/**********************************
* @file timer2.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.18
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU38F20.h"
#include "timer2.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void timer2_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void timer2_init(void);

/***********************************
* @fn  timer2_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/
void timer2_set_pwm_period(unsigned int period);

/***********************************
* @fn  timer2_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/
void timer2_set_pwm_duty(unsigned int duty);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  timer2_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/

void timer2_set_pwm_period(unsigned int period)
{
    unsigned int periodbuf[2]={0};
    periodbuf[0] = (unsigned int)(period >> 8);
	periodbuf[1] = (unsigned int)(period & 0x00ff);
    TM2INH = periodbuf[0];
    TM2IN = periodbuf[1];
}

/***********************************
* @fn  timer2_set_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/

void timer2_set_pwm_duty(unsigned int duty)
{
    unsigned int dutybuf[2]={0};
    dutybuf[0] = (unsigned int)(duty >> 8);
	dutybuf[1] = (unsigned int)(duty & 0x00ff);
    TM2RH = dutybuf[0];
    TM2R = dutybuf[1];
}

/***********************************
* @fn  void timer2_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void timer2_init(void)
{
	timer2_clk_source();	//CKT2的分频时钟
	timer2_div_32();	//cpuclk/32，125KHz
}